/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.database.jdbc;

import ibm.nways.jdm.database.DbAttributeType;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;

public class DbJdbcColumnType
extends DbAttributeType
implements Serializable {
    private static ResourceBundle strings = ResourceBundle.getBundle("ibm.nways.jdm.database.jdbc.DbJdbcResources");
    public static final int NULL = 0;
    public static final int STRING = 1;
    public static final int INTEGER = 2;
    public static final int DOUBLE = 3;
    private static final int FIRST_TYPE = 0;
    private static final int LAST_TYPE = 3;
    public static final int MAX_STRING = 254;
    public static final int MAX_NAME = 18;
    protected int type = 0;
    protected int length;

    public DbJdbcColumnType() {
    }

    public DbJdbcColumnType(int n, int n2) throws IllegalArgumentException {
        this.setType(n);
        this.length = n2;
    }

    public DbJdbcColumnType(int n) throws IllegalArgumentException {
        this(n, n == 1 ? 254 : 1);
    }

    public static boolean isValidNameCharacter(char c) {
        boolean bl = false;
        if (Character.isLetterOrDigit(c) || c == '_' || Character.isISOControl(c)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isValidNameFirstCharacter(char c) {
        boolean bl = false;
        if (Character.isLetter(c) || Character.isISOControl(c)) {
            bl = true;
        }
        return bl;
    }

    public void setType(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        if (this.type == 1) {
            this.length = n;
        }
    }

    public boolean equals(Object object) {
        DbJdbcColumnType dbJdbcColumnType;
        boolean bl = false;
        if (object instanceof DbJdbcColumnType && this.type == (dbJdbcColumnType = (DbJdbcColumnType)object).getType()) {
            bl = true;
        }
        return bl;
    }

    public static String getTypeString(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = strings.getString("STRING");
                break;
            }
            case 2: {
                string = strings.getString("INTEGER");
                break;
            }
            case 3: {
                string = strings.getString("DOUBLE");
                break;
            }
        }
        return string;
    }

    public static Vector getAllTypes() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n <= 3) {
            vector.addElement(DbJdbcColumnType.getTypeString(n));
            ++n;
        }
        return vector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 1: {
                stringBuffer.append("VARCHAR(").append(String.valueOf(this.length)).append(")");
                break;
            }
            case 2: {
                stringBuffer.append("INTEGER");
                break;
            }
            case 3: {
                stringBuffer.append("DOUBLE PRECISION");
                break;
            }
        }
        return stringBuffer.toString();
    }
}

